import db from "../db-config.js";

import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  decodeAndParseFieldsSync,
  deleteRecord,
  insertActivityLog,
  makeJoins,
  processesSingleDDRMDocument,
  processUploadDocuments,
  searchConditionRecord,
  uniqueIdGenerator,
  updateQueryBuilder,
  uploadFile,
  whereCondition,
} from "../helper/general.js";

import { sendResponse } from "../helper/wrapper.js";
import ContractorSiteAccessDocs from "../sequelize/ContractorSiteAccessDocsSchema.js";
import ContractorSiteAccess from "../sequelize/ContractorSiteAccessSchema.js";

export const createUpdateContractorSiteAccess = async (req, res) => {
  let { id, form, sidebar_id = 269 } = req.body;

  // console.log("----------------------------", sidebar_id);
  req.body = (await decodeAndParseFieldsSync([req.body]))[0];

  // console.log(">>>>>>>>>>>>",req.body)

  const documents = await processUploadDocuments(req, sidebar_id);

  if (id && documents.length) {
    const deleteQuery = `UPDATE contractor_site_access_docs SET deleted = 1 where deleted = 0 AND contractor_site_access_id = ?`;
    await db.query(deleteQuery, [id]);
  }
  // for (let i = 0; i <= 5; i++) {
  //   if (req.body[`upload_documents[${i}].file`] || req.files?.[`upload_documents[${i}].file`]) {
  //     const file = req.files[`upload_documents[${i}].file`];
  //     if (typeof file != "string" && typeof file == "object") {
  //       const filePath = await uploadFile("contractor_site_access", file);
  //       document.push({ file: filePath, doc_no: i });
  //     } else {
  //       document.push({
  //         file: req.body[`upload_documents[${i}].file`],
  //         doc_no: i,
  //       });
  //     }
  //   }
  // }

  form = typeof form === "string" ? JSON.parse(form) : form;
  if (form) {
    const contractor = form.contractor;
    if (contractor) {
      const [fetchOrg] = await db.query(
        `SELECT organization , department FROM contractor_registration WHERE id = ${contractor}`
      );

      req.body.organization = fetchOrg[0]?.organization;
      req.body.department = fetchOrg[0]?.department;
    }
    req.body.contractor = contractor;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;

  req.body.contractor = form.contractor;
  // req.body.status = "Pending"; Pending Withdrawn or granted

  if (!id) {
    const unique_id = await uniqueIdGenerator(
      req.body.organization,
      req.body.department,
      "ContractorSiteAccess",
      "contractor_site_access",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
  }

  const { query, values } = id
    ? updateQueryBuilder(ContractorSiteAccess, req.body)
    : createQueryBuilder(ContractorSiteAccess, req.body);

  const [result] = await db.query(query, values);

  if (documents || Array.isArray(documents)) {
    // Iterate through uploaded files
    for (const file of documents) {
      const ddrm_id = file?.ddrm_id;
      const id_doc = file.id;
      // Move the file to the public folder
      // Save file details for database
      const { query: docQuery, values: docValues } = createQueryBuilder(ContractorSiteAccessDocs, {
        doc_no: id_doc,
        contractor_site_access_id: id ? id : result.insertId,
        ddrm_id,
      });

      await db.query(docQuery, docValues);
    }
  }
  // if (document.length > 0) {
  //   for (const doc of document) {
  //     const { query, values } = createQueryBuilder(ContractorSiteAccessDocs, {
  //       ...doc,
  //       contractor_site_access_id: id ? id : result.insertId,
  //     });
  //     await db.query(query, values);
  //   }
  // }
  await insertActivityLog(req.user.sessionid, status, "Contractor SiteAccess", id ? id : result.insertId);
  // send email

  return sendResponse(res, 200, `Record ${status} Successfully`);
};

export const getContractorSiteAccess = async (req, res) => {
  const { id } = req.params;
  console.log("id", id);
  const condition = await whereCondition({
    table: "contractor_site_access",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const searchTableName = [
    "contractor_registration.contractor_name",
    "project_registration.project_title",
    "CONCAT(users.name , ' ' , users.surname)",
  ];

  const searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = contractor_site_access.created_by",
    },
    {
      type: "left",
      targetTable: "contractor_registration",
      onCondition: "contractor_registration.id = contractor_site_access.contractor",
    },
    {
      type: "left",
      targetTable: "project_registration",
      onCondition: "project_registration.id = contractor_site_access.project",
    },
    {
      type: "left",
      targetTable: "repository",
      onCondition: "repository.id = contractor_site_access.ddrm_id",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = contractor_site_access.organization",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const contractorSiteAccessQuery = `SELECT contractor_site_access.* , CONCAT(users.name , ' ' , users.surname) AS created_by_name , organization.name as organization_name, organization.header_image , organization.footer_image , organization.business_logo, contractor_registration.contractor_name AS contractor_name , project_registration.project_title AS project_name,repository.url as documents FROM contractor_site_access ${joinCondition} WHERE contractor_site_access.deleted = 0 ${searchCondition} ${condition}`;

  let [contractorSiteAccess] = await db.query(contractorSiteAccessQuery);

  contractorSiteAccess = await decodeAndParseFields(contractorSiteAccess);
  for (const site of contractorSiteAccess) {
    const id = site.id;
    const [files] = await db.query(
      `SELECT contractor_site_access_docs.*, repository.url as file, document_creation.document_name as title FROM contractor_site_access_docs LEFT JOIN repository ON repository.id = contractor_site_access_docs.ddrm_id LEFT JOIN document_creation ON document_creation.id = repository.document_creation_id WHERE contractor_site_access_docs.deleted = 0 AND contractor_site_access_id = ${id}`
    );

    site.upload_documents = files;
  }

  const totalRecord = await countQueryCondition(contractorSiteAccessQuery);

  return sendResponse(res, 200, contractorSiteAccess, totalRecord);
};

export const deleteContractorSiteAccess = async (req, res) => {
  const { id } = req.params;

  await deleteRecord(ContractorSiteAccess, id);

  await insertActivityLog(req.user.sessionid, "delete", "Contractor SiteAccess", id);

  return sendResponse(res, 200, "Record deleted successfully");
};

export const uploadDocument = async (req, res) => {
  const { id, ddrm_id } = req.body;
  // let document = "";
  // if (req.files && req.files.document) {
  //   let file;
  //   if (Array.isArray(req.files.document)) {
  //     file = req.files.document[0];
  //   } else {
  //     file = req.files.document;
  //   }
  //   document = await uploadFile("contractor_site_access", file);
  // } else {
  //   document = req.body.document;
  // }
  // console.log("req.files.document: ", req.files);
  const [result] = await db.query(`UPDATE contractor_site_access SET ddrm_id = ? WHERE id = ?`, [ddrm_id, id]);
  if (result.affectedRows > 0) {
    return sendResponse(res, 200, "Document uploaded successfully");
  }
  return sendResponse(res, 400, "Error updating document");
};
