import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  encodeAndStringifyFields,
  decodeAndParseFields,
  deleteRecord,
  uploadFile,
  updateQueryBuilder,
  createQueryBuilder,
} from "../helper/general.js";
import DDRM from "../sequelize/DdrmSchema.js";

export const createUpdateDDRM = async (req, res) => {
  let { id, organization } = req.body;
  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;

  if (!organization || organization?.length === 0) {
    return sendResponse(
      res,
      200,
      "Please select at least one business structure"
    );
  }


  // if (req.files && req.files.document) {
  //   req.body.document = await uploadFile(
  //     "ddrm",
  //     req.files.document
  //   );
  // }

  req.body = await encodeAndStringifyFields(req.body);

  const { query, values } = id
    ? updateQueryBuilder(DDRM, req.body)
    : createQueryBuilder(DDRM, req.body);

  const [result] = await db.query(query, values);
  await insertActivityLog(
    req.user.sessionid,
    status,
    "DDRM",
    id ? id : result.insertId
  );
  return sendResponse(res, 200, `Record  ${status} Successfully`);
};

export const getDDRM = async (req, res) => {
  const { id } = req.params;

  const condition = await whereCondition({
    table: "ddrm",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const searchTableName = ["ddrm.name"];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = ddrm.created_by",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = ddrm.organization",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const ddrmQuery = `SELECT ddrm.* ,CONCAT(createdUser.name , ' ' , createdUser.surname) AS created_by_name , createdUser.profile AS created_by_profile , organization.name AS organization_name  FROM ddrm  ${joinCondition} WHERE ddrm.deleted = 0 ${searchCondition} ${condition}`;

  let [ddrm] = await db.query(ddrmQuery);

  ddrm = await decodeAndParseFields(ddrm);

  const totalRecord = await countQueryCondition(ddrmQuery);
  return sendResponse(res, 200, ddrm, totalRecord);
};

export const deleteDDRM = async (req, res) => {
  const { id } = req.params;
  await deleteRecord(DDRM, id);
  await insertActivityLog(
    req.user.sessionid,
    "delete",
    "ddrm",
    id
  );
  return sendResponse(res, 200, "Record Deleted Successfully");
};
