import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  getFirstCreatedAndAllOrganizationIds,
  uniqueIdGenerator,
  encodeAndStringifyFields,
  updateQueryBuilder,
  createQueryBuilder,
  getFilterConditions,
  getListingData,
  getRecord,
} from "../helper/general.js";
import MainProcess from "../sequelize/MainProcessSchema.js";

/** Function to create or update MainProcess */
export const createUpdateMainProcess = async (req, res) => {
  const { id, name, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(
      res,
      404,
      "Please Select at least one business Structure"
    );
  }

  const [checkNameWithOrganization] = await getRecord(
    "main_process",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Main Process name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Main Process name already exist");
    }
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "MainProcess",
      "main_process",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(MainProcess, req.body)
    : createQueryBuilder(MainProcess, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(
    req.user.sessionid,
    status,
    "MainProcess",
    id ? id : result.insertId
  );
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdateMainProcess = async (req, res) => {
//   const { id, name, description } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   if (id) {
//     const result = await settingsUpdater(
//       MainProcess,
//       req.body.organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     await insertActivityLog(req.user.sessionid, "update", "MainProcess", `This user updated MainProcess with id: ${id}`);
//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const insertPromises = req.body.organization.map(async (org) => {
//       const [checkName] = await db.query(`SELECT name FROM main_process WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
//       if (checkName.length === 0) {
//         await db.query(`INSERT INTO main_process (name, description, created_by, organization) VALUES (?, ?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org]);
//         await insertActivityLog(req.user.sessionid, "create", "MainProcess", `This user created a new MainProcess '${name}' for organization ${org}`);
//       }
//     });
//     await Promise.all(insertPromises);
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/** Function to view all or single MainProcess */
export const viewMainProcess = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "main_process"
  );

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "main_process",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  const searchFields = [
    "main_process.name",
    "main_process.description",
    "users.name",
  ];
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchFields
  );
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = main_process.created_by",
    },
    // { type: "left", targetTable: "organization", onCondition: "organization.id = main_process.organization" }
  ];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT main_process.*, CONCAT(users.name, ' ', users.surname) AS created_by, main_process.organization AS organizations FROM main_process ${joinsRecord} WHERE main_process.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //    if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM main_process WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete MainProcess */
export const deleteMainProcess = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("main_process", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "MainProcess", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
