import db from "../db-config.js";
import {
  insertActivityLog,
  getOrganizationAccordingToDepartment,
  addUpdateObjectiveManagementPlan,
  countQueryCondition,
  makeJoins,
  deleteRecord,
  encodeSingle_statement,
  encodeTheEditorContent,
  decodeSingle_statement,
  uniqueIdGenerator,
  updateQueryBuilder,
  createQueryBuilder,
  whereCondition,
  searchConditionRecord,
  decodeAndParseFields,
  insertNotification,
  processesSingleDDRMDocument,
  updateArchiveRepoDoc,
} from "../helper/general.js";
import ObjectiveSetting from "../sequelize/ObjectiveSettingSchema.js";
import { sendResponse } from "../helper/wrapper.js";
import { uploadToDDRM } from "../helper/ddrmUploader.js";
import {
  createUpdateActionFunction,
  getCustomActionFunction,
} from "./customActionCreationController.js";
import ObjectiveSettingTargetPlan from "../sequelize/ObjectiveSettingTargetPlanSchema.js"; // for sync purpose only not to be removed
/**Function to create or update objective setting  */
export const createUpdateObjectiveSetting = async (req, res) => {
  req.body = (await decodeAndParseFields([req.body]))[0];
  const {
    id,
    objective_description,
    task_data,
    target_description,
    management_plan_description,
    management_plan_actions,
    organization,
    department,
    sidebar_id = 76,
    action_taken,
  } = req.body;

  let organizationId = organization;

  if (department) {
    const recordAccordingToOrganization =
      await getOrganizationAccordingToDepartment(department);
    organizationId = recordAccordingToOrganization[0].organization;
    req.body.organization = organizationId;
  }

  const actionTaken = [];
  for (let i = 0; i < task_data.length; i++) {
    let taskData = task_data[i];
    taskData.approved = false;
    const data = {
      task_data: [taskData],
      department,
      files: req.files,
      user: req.user,
      id: action_taken[i],
      organization: organizationId,
      sidebar_id,
    };

    if (data?.task_data && data?.task_data[0] && data?.task_data[0]?.role) {
      const { status, arr } = await createUpdateActionFunction(data, req);
      if (status) {
        const action_taken = arr[0].id;
        actionTaken.push(action_taken);
      }
    }
  }

  req.body.action_taken = actionTaken;

  // for (let i = 0; i < task_data.length; i++) {
  //   let data = task_data[i];
  //   const file = req.files && req.files[`task_data[${i}][attachment]`];

  //   if (file) {
  //     const ddrm_id = await uploadToDDRM(sidebar_id, file, req);
  //     data.ddrm_id = ddrm_id;

  //     const old_ddrm_id = item?.ddrm_id;
  //     if (old_ddrm_id) {
  //       await updateArchiveRepoDoc(old_ddrm_id);
  //     }
  //   } else {
  //     data.ddrm_id = req.body[`task_data[${i}][ddrm_id]`];
  //   }
  // }

  // let encodedManagementPlanActions = await encodeTheEditorContent(
  //   management_plan_actions,
  //   "action_description"
  // );
  // encodedManagementPlanActions = encodedManagementPlanActions.map((e) => {
  //   return {
  //     ...e,
  //     organization: organization ?? null,
  //   };
  // });

  req.body.management_plan_description = await encodeSingle_statement(
    management_plan_description
  );
  // req.body.management_plan_actions = await encodeTheEditorContent(management_plan_actions, "action_description");
  req.body.objective_description = await encodeSingle_statement(
    objective_description
  );
  req.body.target_description = await encodeSingle_statement(
    target_description
  );

  req.body.objective_target_id = "123" || (await uniqueIdGenerator());
  req.body.target_id = "456";
  req.body.management_plan_target_id = "789";
  /**Check record if organization is not coming then fetch organization according to department */

  /**If id comes in body then it will update the query */
  if (id) {
    req.body.updated_by = req.user.sessionid;
    /**Update Objective Setting Query */
    const { query, values } = updateQueryBuilder(ObjectiveSetting, req.body);

    await db.query(query, values);

    /**Insert Activity  */
    insertActivityLog(req.user.sessionid, "update", "Objective Setting", id);

    //  subject, message, user, messageType, sender;
    await insertNotification(
      "Objective Setting Updated",
      "This user updated the Objective Setting",
      req.body.objective_owner,
      "text",
      req.user.sessionid
    );

    // await addUpdateObjectiveManagementPlan(
    //   id,
    //   req.user.sessionid,
    //   encodedManagementPlanActions
    // );

    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const unique_id = await uniqueIdGenerator(
      organizationId,
      department,
      "OS",
      "objective_setting",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.created_by = req.user.sessionid;
    /**Insert record for Objective Setting */
    const { query, values } = createQueryBuilder(ObjectiveSetting, req.body);
    const [createObjectiveSetting] = await db.query(query, values);

    /**Insert record for activity log */
    insertActivityLog(
      req.user.sessionid,
      "create",
      "Objective Setting",
      createObjectiveSetting.insertId
    );

    await insertNotification(
      "Objective Setting created",
      "This user created the Objective Setting",
      req.body.objective_owner,
      "text",
      req.user.sessionid
    );

    // await addUpdateObjectiveManagementPlan(
    //   createObjectiveSetting.insertId,
    //   req.user.sessionid,
    //   encodedManagementPlanActions
    // );

    return sendResponse(res, 200, "Record created successfully");
  }
};

/**Function to view all objective setting */
export const viewAllObjectiveSetting = async (req, res) => {
  const { id } = req.params;

  const condition = await whereCondition({
    table: "objective_setting",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    user: req.user,
  });

  const searchTableName = [
    // "objective_setting.parent_objective_name",
    "objective_setting.objective_name",
    "objective_setting.objective_description",
    "objective_setting.type_of_resources",
    "objective_setting.target_name",
    "objective_setting.kpi_name",
    "objective_setting.source",
    "objective_setting.level_of_legislation",
    "objective_setting.management_plan_description",
    "CONCAT(users.name , ' ' , users.surname)",
    "organization.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = objective_setting.created_by",
    },
    {
      type: "left",
      targetTable: "users as objectiveOwner",
      onCondition: "objectiveOwner.id = objective_setting.objective_owner",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = objective_setting.organization",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = objective_setting.department",
    },
    {
      type: "left",
      targetTable: "measurement_metric",
      onCondition:
        "measurement_metric.id = objective_setting.measurement_metric",
    },
  ];

  const joinsRecord = await makeJoins(joins);

  //  objective_setting.parent_objective,
  //  objective_setting.parent_objective_name,
  /**Record of all meetings */
  const objectiveSettingQuery = `SELECT 
     objective_setting.*,
     objective_setting.created_by as created_by_id,
     users.name as created_by,users.surname as created_by_surname, 
     users.profile as created_by_profile, 
     organization.name as organization_name, 
     objectiveOwner.name as objective_owner_name,
     objectiveOwner.surname as objective_owner_surname, 
     objectiveOwner.profile as objective_owner_profile,
     measurement_metric.name as measurement_metric_name
       FROM objective_setting 
       ${joinsRecord} where objective_setting.deleted = 0 ${searchCondition} ${condition}`;
  let [objectiveSetting] = await db.query(objectiveSettingQuery);

  objectiveSetting = await decodeAndParseFields(objectiveSetting);

  /** table name list for associated risks selection */
  let associated_risks_obj = {
    "Tactical Risk": "tactical_risk_identification",
    "Operational Risk": "operational_risk_identification",
    "Strategic Risk": "strategic_risk_identification",
  };
  const actionTakenData = [];
  for (const objectiveSettingData of objectiveSetting) {
    const actionTaken = objectiveSettingData.action_taken;
    if (actionTaken) {
      for (let record of actionTaken) {
        const data = {
          params: { id: record },
          user: req.user,
          query: {},
        };
        const [customActionData] = await getCustomActionFunction(data);
        actionTakenData.push(customActionData);
      }
      objectiveSettingData.task_data = actionTakenData;
    }
    if (objectiveSettingData.prioritized_risks) {
      const possibleJoins = {
        strategic_risk_identification: "strategic_risk",
        tactical_risk_identification: "tactical_risk",
        operational_risk_identification: "operational_risk",
      };
      const [prioritizedRiskRecord] = await db.query(`SELECT ${
        possibleJoins[objectiveSettingData.risk_type]
      }.risk_register_name as prioritized_risks_name FROM ${
        objectiveSettingData.risk_type
      }
            LEFT JOIN ${possibleJoins[objectiveSettingData.risk_type]} ON ${
        possibleJoins[objectiveSettingData.risk_type]
      }.id = ${objectiveSettingData.risk_type}.risk_register_id WHERE ${
        objectiveSettingData.risk_type
      }.id = ${objectiveSettingData.prioritized_risks}`);
      objectiveSettingData.prioritized_risks_name =
        prioritizedRiskRecord[0]?.prioritized_risks_name;
    }
    /** add associated risks name  */
    // const associated_risks = JSON.parse(objectiveSettingData.associated_risks);
    // if (
    //   associated_risks?.length > 0 &&
    //   associated_risks_obj[objectiveSettingData.parent_objective_name]
    // ) {
    //   const associatedRiskQuery = `SELECT id, risk_name FROM ${
    //     associated_risks_obj[objectiveSettingData.parent_objective_name]
    //   } WHERE id IN (${associated_risks})`;
    //   const [associatedRisk] = await db.query(associatedRiskQuery);
    //   objectiveSettingData.associated_risks_name = associatedRisk;
    // }
  }
  const result = objectiveSetting;

  const totalRecord = await countQueryCondition(objectiveSettingQuery);

  return sendResponse(res, 200, result, totalRecord);
};
export const viewAllApprovalWorkflowObjectiveSetting = async (req, res) => {
  const { id } = req.params;

  const condition = await whereCondition({
    table: "objective_setting",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    user: req.user,
  });

  const searchTableName = [
    // "objective_setting.parent_objective_name",
    "objective_setting.objective_name",
    "objective_setting.objective_description",
    "objective_setting.type_of_resources",
    "objective_setting.target_name",
    "objective_setting.kpi_name",
    "objective_setting.management_plan_description",
    "CONCAT(users.name , ' ' , users.surname)",
    "organization.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = objective_setting.created_by",
    },
    {
      type: "left",
      targetTable: "users as objectiveOwner",
      onCondition: "objectiveOwner.id = objective_setting.objective_owner",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = objective_setting.organization",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = objective_setting.department",
    },
    {
      type: "left",
      targetTable: "measurement_metric",
      onCondition:
        "measurement_metric.id = objective_setting.measurement_metric",
    },
  ];

  const joinsRecord = await makeJoins(joins);
  let ownerCondition = "";
  if (req.user.isSuperAdmin !== 1) {
    ownerCondition = `AND objective_setting.objective_owner = ${req.user.sessionid}`;
  }

  //  objective_setting.parent_objective,
  //  objective_setting.parent_objective_name,
  /**Record of all meetings */
  const objectiveSettingQuery = `SELECT 
  objective_setting.*,
  objective_setting.created_by as created_by_id,
  users.name as created_by,users.surname as created_by_surname, 
     users.profile as created_by_profile, 
     organization.name as organization_name, 
     objectiveOwner.name as objective_owner_name,
     objectiveOwner.surname as objective_owner_surname, 
     objectiveOwner.profile as objective_owner_profile,
     measurement_metric.name as measurement_metric_name
     FROM objective_setting 
     ${joinsRecord} where objective_setting.deleted = 0 ${ownerCondition} ${searchCondition} ${condition}`;
  let [objectiveSetting] = await db.query(objectiveSettingQuery);

  objectiveSetting = await decodeAndParseFields(objectiveSetting);

  /** table name list for associated risks selection */
  let associated_risks_obj = {
    "Tactical Risk": "tactical_risk_identification",
    "Operational Risk": "operational_risk_identification",
    "Strategic Risk": "strategic_risk_identification",
  };
  /**Get Objective Setting Target Plan */
  const actionTakenData = [];
  for (const objectiveSettingData of objectiveSetting) {
    const actionTaken = objectiveSettingData.action_taken;
    if (actionTaken) {
      for (let record of actionTaken) {
        const data = {
          params: { id: record },
          user: req.user,
          query: {},
        };
        const [customActionData] = await getCustomActionFunction(data);
        actionTakenData.push(customActionData);
      }
      objectiveSettingData.task_data = actionTakenData;
    }
    if (objectiveSettingData.prioritized_risks) {
      const possibleJoins = {
        strategic_risk_identification: "strategic_risk",
        tactical_risk_identification: "tactical_risk",
        operational_risk_identification: "operational_risk",
      };
      const [prioritizedRiskRecord] = await db.query(`SELECT ${
        possibleJoins[objectiveSettingData.risk_type]
      }.risk_register_name as prioritized_risks_name FROM ${
        objectiveSettingData.risk_type
      }
            LEFT JOIN ${possibleJoins[objectiveSettingData.risk_type]} ON ${
        possibleJoins[objectiveSettingData.risk_type]
      }.id = ${objectiveSettingData.risk_type}.risk_register_id WHERE ${
        objectiveSettingData.risk_type
      }.id = ${objectiveSettingData.prioritized_risks}`);
      objectiveSettingData.prioritized_risks_name =
        prioritizedRiskRecord[0]?.prioritized_risks_name;
    }
    /** add associated risks name  */
    // const associated_risks = JSON.parse(objectiveSettingData.associated_risks);
    // if (
    //   associated_risks?.length > 0 &&
    //   associated_risks_obj[objectiveSettingData.parent_objective_name]
    // ) {
    //   const associatedRiskQuery = `SELECT id, risk_name FROM ${
    //     associated_risks_obj[objectiveSettingData.parent_objective_name]
    //   } WHERE id IN (${associated_risks})`;
    //   const [associatedRisk] = await db.query(associatedRiskQuery);
    //   objectiveSettingData.associated_risks_name = associatedRisk;
    // }
  }
  const result = objectiveSetting;

  const totalRecord = await countQueryCondition(objectiveSettingQuery);

  return sendResponse(res, 200, result, totalRecord);
};

/**Function to delete a specific role */
export const deleteObjectiveSetting = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteRecord("objective_setting", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    insertActivityLog(req.user.sessionid, "delete", "Objective Setting", id);
    return res.status(200).json({
      status: true,
      message: "Record deleted successfully",
    });
  }
};

/**Function to get Objective Target Management Plan Actions */
export const viewAllObjectiveTargetManagementPlan = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "objective_setting",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    user: req.user,
  });

  const searchTableName = ["objective_setting_target_plan.action_title"];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition:
        "users.id = objective_setting_target_plan.responsible_person",
    },
    {
      type: "left",
      targetTable: "objective_setting",
      onCondition:
        "objective_setting.id = objective_setting_target_plan.objective_setting_id",
    },
    {
      type: "left",
      targetTable: "department as responsible_department",
      onCondition:
        "responsible_department.id = objective_setting_target_plan.responsible_person",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = objective_setting.organization",
    },
  ];

  const joinsRecord = await makeJoins(joins);

  /**Record of all Objective settings target plans */
  const objectiveSettingQuery = `SELECT 
  objective_setting_target_plan.id,
  objective_setting_target_plan.objective_setting_id,
  objective_setting_target_plan.action_title,
  objective_setting_target_plan.action_description,
  objective_setting_target_plan.responsible_department,
  responsible_department.name as responsible_department_name,
  objective_setting_target_plan.responsible_person as responsible_person_id,
  objective_setting_target_plan.start_date,
  objective_setting_target_plan.due_date,
  objective_setting_target_plan.action_progress_description,
  objective_setting_target_plan.action_progress_status,
  objective_setting_target_plan.created_by as created_by_id,
  objective_setting.organization,
  objective_setting.objective_name,
   users.name as responsible_person,users.surname as responsible_person_surname , 
   users.profile as responsible_person_profile,
   organization.name as organization_name,
   objective_setting.status
     FROM objective_setting_target_plan 
     ${joinsRecord} where objective_setting_target_plan.deleted = 0 ${searchCondition} ${condition}`;
  const [objectiveSetting] = await db.query(objectiveSettingQuery);

  for (const item of objectiveSetting) {
    item.action_description = await decodeSingle_statement(
      item.action_description
    );
  }

  const totalRecord = await countQueryCondition(objectiveSettingQuery);

  return sendResponse(res, 200, objectiveSetting, totalRecord);
};

/**Function to approve Objective Target Management Plan Actions */
export const updateActionProgressStatus = async (req, res) => {
  const { id, action_progress_status, action_progress_description } = req.body;
  await db.query(
    `UPDATE objective_setting_target_plan SET action_progress_status = '${action_progress_status}' , action_progress_description = '${action_progress_description}' WHERE id = ${id}`
  );
  return res.status(200).json({
    status: true,
    message: "Record updated successfully",
  });
};
export const updateApprovalStatus = async (req, res) => {
  const { id, status, remark, action_taken } = req.body;
  let where = "";
  if (remark) {
    where = ` , remark = '${remark}' `;
  }
  await db.query(
    `UPDATE objective_setting SET status = '${status}' ${where}  WHERE id = ${id}`
  );
  if (action_taken && action_taken.length) {
    await db.query(
      `UPDATE custom_action_creation SET approved = 1 WHERE id IN (${action_taken})`
    );
  }
  return res.status(200).json({
    status: true,
    message: `Record ${status} successfully`,
  });
};
