import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdateActivityLocation,
  deleteActivityLocation,
  viewActivityLocation,
} from "../controller/activityLocationController.js";

/**
 * @swagger
 * tags:
 *   name:  activity location
 *   description: API operations for managing  activity location
 */
const activityLocationRoutes = Router();

/**
 * @swagger
 * /api/activityLocation/create-update-activity-location:
 *   post:
 *     summary: Create or update a  activity location
 *     tags: [ activity location]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
activityLocationRoutes.post(
  "/create-update-activity-location",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(
      req.body.id ? "edit" : "create",
      438,
      "activity_location"
    )(req, res, next);
  },
  controllerWrapper(createUpdateActivityLocation)
);

/**
 * @swagger
 * /api/activityLocation/get-activity-location:
 *   get:
 *     summary: Get all records of  activity location
 *     tags: [ activity location]
 */
activityLocationRoutes.get(
  "/get-activity-location",
  verifyToken,
  sideBarPermissionCheck("view", 438, "activity_location"),
  controllerWrapper(viewActivityLocation)
);

/**
 * @swagger
 * /api/activityLocation/get-activity-location/{id}:
 *   get:
 *     summary: Get a specific record of  activity location
 *     tags: [ activity location]
 */
activityLocationRoutes.get(
  "/get-activity-location/:id",
  verifyToken,
  sideBarPermissionCheck("view", 438, "activity_location"),
  controllerWrapper(viewActivityLocation)
);

/**
 * @swagger
 * /api/activityLocation/delete-activity-location/{id}:
 *   delete:
 *     summary: Delete a specific record of  activity location
 *     tags: [ activity location]
 */
activityLocationRoutes.delete(
  "/delete-activity-location/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 438, "activity_location"),
  controllerWrapper(deleteActivityLocation)
);

export default activityLocationRoutes;
