import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { viewBodyPart } from "../controller/bodyPartController.js";

/**
 * @swagger
 * tags:
 *   name:  Body Part
 *   description: API operations for managing  Body Part
 */
const bodyPartRoutes = Router();

/**
 * @swagger
 * /api/bodyPart/get-body-part:
 *   get:
 *     summary: Get all records of  Body Part
 *     tags: [ Body Part]
 */
bodyPartRoutes.get(
  "/get-body-part",
  verifyToken,
  sideBarPermissionCheck("view", 391, "body_part"),
  controllerWrapper(viewBodyPart)
);

export default bodyPartRoutes;
