import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateCompetenciesAssessed, deleteCompetenciesAssessed, viewCompetenciesAssessed } from "../controller/competenciesAssessedController.js";

/**
 * @swagger
 * tags:
 *   name:  competencies assessed
 *   description: API operations for managing  competencies assessed
 */
const competenciesAssessedRoutes = Router();

/**
 * @swagger
 * /api/competenciesAssessed/create-update-competencies-assessed:
 *   post:
 *     summary: Create or update a  competencies assessed
 *     tags: [ competencies assessed]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
competenciesAssessedRoutes.post(
  "/create-update-competencies-assessed",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 456 , "competencies_assessed")(req, res, next);
  },
  controllerWrapper(createUpdateCompetenciesAssessed)
);

/**
 * @swagger
 * /api/competenciesAssessed/get-competencies-assessed:
 *   get:
 *     summary: Get all records of  competencies assessed
 *     tags: [ competencies assessed]
 */
competenciesAssessedRoutes.get(
  "/get-competencies-assessed",
  verifyToken,
  sideBarPermissionCheck("view", 456, "competencies_assessed"),
  controllerWrapper(viewCompetenciesAssessed)
);

/**
 * @swagger
 * /api/competenciesAssessed/get-competencies-assessed/{id}:
 *   get:
 *     summary: Get a specific record of  competencies assessed
 *     tags: [ competencies assessed]
 */
competenciesAssessedRoutes.get(
  "/get-competencies-assessed/:id",
  verifyToken,
  sideBarPermissionCheck("view", 456, "competencies_assessed"),
  controllerWrapper(viewCompetenciesAssessed)
);

/**
 * @swagger
 * /api/competenciesAssessed/delete-competencies-assessed/{id}:
 *   delete:
 *     summary: Delete a specific record of  competencies assessed
 *     tags: [ competencies assessed]
 */
competenciesAssessedRoutes.delete(
  "/delete-competencies-assessed/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 456, "competencies_assessed"),
  controllerWrapper(deleteCompetenciesAssessed)
);

export default competenciesAssessedRoutes;