import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateDefectDetectionMethod, deleteDefectDetectionMethod, viewDefectDetectionMethod } from "../controller/defectDetectionMethodController.js";

/**
 * @swagger
 * tags:
 *   name:  defect detection method
 *   description: API operations for managing  defect detection method
 */
const defectDetectionMethodRoutes = Router();

/**
 * @swagger
 * /api/defectDetectionMethod/create-update-defect-detection-method:
 *   post:
 *     summary: Create or update a  defect detection method
 *     tags: [ defect detection method]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
defectDetectionMethodRoutes.post(
  "/create-update-defect-detection-method",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 415 , "defect_detection_method")(req, res, next);
  },
  controllerWrapper(createUpdateDefectDetectionMethod)
);

/**
 * @swagger
 * /api/defectDetectionMethod/get-defect-detection-method:
 *   get:
 *     summary: Get all records of  defect detection method
 *     tags: [ defect detection method]
 */
defectDetectionMethodRoutes.get(
  "/get-defect-detection-method",
  verifyToken,
  sideBarPermissionCheck("view", 415, "defect_detection_method"),
  controllerWrapper(viewDefectDetectionMethod)
);

/**
 * @swagger
 * /api/defectDetectionMethod/get-defect-detection-method/{id}:
 *   get:
 *     summary: Get a specific record of  defect detection method
 *     tags: [ defect detection method]
 */
defectDetectionMethodRoutes.get(
  "/get-defect-detection-method/:id",
  verifyToken,
  sideBarPermissionCheck("view", 415, "defect_detection_method"),
  controllerWrapper(viewDefectDetectionMethod)
);

/**
 * @swagger
 * /api/defectDetectionMethod/delete-defect-detection-method/{id}:
 *   delete:
 *     summary: Delete a specific record of  defect detection method
 *     tags: [ defect detection method]
 */
defectDetectionMethodRoutes.delete(
  "/delete-defect-detection-method/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 415, "defect_detection_method"),
  controllerWrapper(deleteDefectDetectionMethod)
);

export default defectDetectionMethodRoutes;