import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import {
  createUpdateCategories,
  deleteCategories,
  getCategories,
} from "../controller/documentCategoriesController.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";

const DocumentCategoriesRoutes = Router();

DocumentCategoriesRoutes.post(
  "/create-update-document-category",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(
      req.body.id ? "edit" : "create",
      430,
      "document_categories"
    )(req, res, next);
  },
  createUpdateCategories
);

DocumentCategoriesRoutes.get(
  "/get-document-category",
  verifyToken,
  sideBarPermissionCheck("view", 173, "document_categories"),
  getCategories
);

DocumentCategoriesRoutes.get(
  "/get-document-category/:id",
  verifyToken,
  sideBarPermissionCheck("view", 173, "document_categories"),
  getCategories
);

DocumentCategoriesRoutes.delete(
  "/delete-document-category/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 173, "document_categories"),
  deleteCategories
);

export default DocumentCategoriesRoutes;
