import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateGender, deleteGender, viewGender } from "../controller/genderController.js";

/**
 * @swagger
 * tags:
 *   name:  gender
 *   description: API operations for managing  gender
 */
const genderRoutes = Router();

/**
 * @swagger
 * /api/gender/create-update-gender:
 *   post:
 *     summary: Create or update a  gender
 *     tags: [ gender]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
genderRoutes.post(
  "/create-update-gender",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 368 , "gender")(req, res, next);
  },
  controllerWrapper(createUpdateGender)
);

/**
 * @swagger
 * /api/gender/get-gender:
 *   get:
 *     summary: Get all records of  gender
 *     tags: [ gender]
 */
genderRoutes.get(
  "/get-gender",
  verifyToken,
  sideBarPermissionCheck("view", 368, "gender"),
  controllerWrapper(viewGender)
);

/**
 * @swagger
 * /api/gender/get-gender/{id}:
 *   get:
 *     summary: Get a specific record of  gender
 *     tags: [ gender]
 */
genderRoutes.get(
  "/get-gender/:id",
  verifyToken,
  sideBarPermissionCheck("view", 368, "gender"),
  controllerWrapper(viewGender)
);

/**
 * @swagger
 * /api/gender/delete-gender/{id}:
 *   delete:
 *     summary: Delete a specific record of  gender
 *     tags: [ gender]
 */
genderRoutes.delete(
  "/delete-gender/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 368, "gender"),
  controllerWrapper(deleteGender)
);

export default genderRoutes;