import { Router } from "express";
import { controllerWrapper } from "../helper/wrapper.js";
import { getHospital } from "../controller/hospitalController.js";
import { verifyToken } from "../helper/tokenVerify.js";

/**
 * @swagger
 * tags:
 *   name:  hospital
 *   description: API operations for managing  hospital
 */
const hospitalRoutes = Router();

/**
 * @swagger
 * /api/hospital/get-hospital:
 *   get:
 *     summary: Get all records of Hospital
 *     tags: [ hospital]
 */
hospitalRoutes.get("/get-hospital", verifyToken, controllerWrapper(getHospital));

export default hospitalRoutes;
