import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdateInspectionLocation,
  deleteInspectionLocation,
  viewInspectionLocation,
} from "../controller/inspectionLocationController.js";

/**
 * @swagger
 * tags:
 *   name:  inspection location
 *   description: API operations for managing  inspection location
 */
const inspectionLocationRoutes = Router();

/**
 * @swagger
 * /api/inspectionLocation/create-update-inspection-location:
 *   post:
 *     summary: Create or update a  inspection location
 *     tags: [ inspection location]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
inspectionLocationRoutes.post(
  "/create-update-inspection-location",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(
      req.body.id ? "edit" : "create",
      390,
      "inspection_location"
    )(req, res, next);
  },
  controllerWrapper(createUpdateInspectionLocation)
);

/**
 * @swagger
 * /api/inspectionLocation/get-inspection-location:
 *   get:
 *     summary: Get all records of  inspection location
 *     tags: [ inspection location]
 */
inspectionLocationRoutes.get(
  "/get-inspection-location",
  verifyToken,
  sideBarPermissionCheck("view", 390, "inspection_location"),
  controllerWrapper(viewInspectionLocation)
);

/**
 * @swagger
 * /api/inspectionLocation/get-inspection-location/{id}:
 *   get:
 *     summary: Get a specific record of  inspection location
 *     tags: [ inspection location]
 */
inspectionLocationRoutes.get(
  "/get-inspection-location/:id",
  verifyToken,
  sideBarPermissionCheck("view", 390, "inspection_location"),
  controllerWrapper(viewInspectionLocation)
);

/**
 * @swagger
 * /api/inspectionLocation/delete-inspection-location/{id}:
 *   delete:
 *     summary: Delete a specific record of  inspection location
 *     tags: [ inspection location]
 */
inspectionLocationRoutes.delete(
  "/delete-inspection-location/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 390, "inspection_location"),
  controllerWrapper(deleteInspectionLocation)
);

export default inspectionLocationRoutes;
