import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdatePhysicalLocation, deletePhysicalLocation, viewPhysicalLocation } from "../controller/physicalLocationController.js";

/**
 * @swagger
 * tags:
 *   name:  physical location
 *   description: API operations for managing  physical location
 */
const physicalLocationRoutes = Router();

/**
 * @swagger
 * /api/physicalLocation/create-update-physical-location:
 *   post:
 *     summary: Create or update a  physical location
 *     tags: [ physical location]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" , parent_location: "parent_location_id"}
 */
physicalLocationRoutes.post(
  "/create-update-physical-location",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 371 , "physical_location")(req, res, next);
  },
  controllerWrapper(createUpdatePhysicalLocation)
);

/**
 * @swagger
 * /api/physicalLocation/get-physical-location:
 *   get:
 *     summary: Get all records of  physical location
 *     tags: [ physical location]
 */
physicalLocationRoutes.get(
  "/get-physical-location",
  verifyToken,
  sideBarPermissionCheck("view", 371, "physical_location"),
  controllerWrapper(viewPhysicalLocation)
);

/**
 * @swagger
 * /api/physicalLocation/get-physical-location/{id}:
 *   get:
 *     summary: Get a specific record of  physical location
 *     tags: [ physical location]
 */
physicalLocationRoutes.get(
  "/get-physical-location/:id",
  verifyToken,
  sideBarPermissionCheck("view", 371, "physical_location"),
  controllerWrapper(viewPhysicalLocation)
);

/**
 * @swagger
 * /api/physicalLocation/delete-physical-location/{id}:
 *   delete:
 *     summary: Delete a specific record of  physical location
 *     tags: [ physical location]
 */
physicalLocationRoutes.delete(
  "/delete-physical-location/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 371, "physical_location"),
  controllerWrapper(deletePhysicalLocation)
);

export default physicalLocationRoutes;