import { Router } from "express";
import { controllerWrapper } from "../helper/wrapper.js";
import { getPoliceStation } from "../controller/policeStationController.js";

/**
 * @swagger
 * tags:
 *   name:  police station
 *   description: API operations for managing  police station
 */
const policeStationRoutes = Router();

/**
 * @swagger
 * /api/policeStation/get-police-station:
 *   get:
 *     summary: Get all records of  police station
 *     tags: [ police station]
 */
policeStationRoutes.get(
  "/get-police-station",
  controllerWrapper(getPoliceStation)
);

/**
 * @swagger
 * /api/policeStation/get-police-station/{id}:
 *   get:
 *     summary: Get a specific record of  police station
 *     tags: [ police station]
 */
policeStationRoutes.get(
  "/get-police-station/:id",
  controllerWrapper(getPoliceStation)
);

/**
 * @swagger
 * /api/policeStation/get-police-station/{id}:
 *   get:
 *     summary: Get a specific record of  police station
 *     tags: [ police station]
 */
policeStationRoutes.get(
  "/get-police-station/city/:city_id",
  controllerWrapper(getPoliceStation)
);

export default policeStationRoutes;
