import { Router } from "express";
import usersRoutes from "./usersRoutes.js";
import organizationRoutes from "./organizationRoutes.js";
import departmentRoutes from "./departmentRoutes.js";
import incidentCategoryRoutes from "./incidentCategoryRoutes.js";
import responsibilityRoutes from "./responsibilityRoutes.js";
import issuingAuthorityRoutes from "./issuingAuthorityRoutes.js";
import permitLicenseRoutes from "./permitLicenseRoutes.js";
import documentTypeRoutes from "./documentTypeRoutes.js";
import focusAreaRoutes from "./focusAreaRoutes.js";
import auditCategoryRoutes from "./auditCategoryRoutes.js";
import SkillRoutes from "./skillsRoutes.js";
import licenseRoutes from "./licenseRoutes.js";
import appointmentTypeRoutes from "./appointmentTypeRoutes.js";
import parentObjectiveRoutes from "./parentObjectiveRoutes.js";
import measurementMetricRoutes from "./measurementMetricRoutes.js";
import categoryTypeRoutes from "./categoryTypeRoutes.js";
import auditTemplateRoutes from "./auditTemplateRoutes.js";
import rolesRoutes from "./rolesRoutes.js";
import hseAppointmentRoutes from "./hseAppointmentRoutes.js";
import strategicRiskRoutes from "./strategicRiskRoutes.js";
import strategicRiskIdentificationRoutes from "./strategicRiskIdentificationRoutes.js";
import meetingRoutes from "./meetingRoutes.js";
import meetingRecordingRoutes from "./meetingRecordingRoutes.js";
import meetingApprovalRoutes from "./meetingApprovalRoutes.js";
import tacticalRiskRoutes from "./tacticalRiskRoutes.js";
import tacticalRiskIdentificationRoutes from "./tacticalRiskIdentificationRoutes.js";
import operationalRiskRegisterRoutes from "./operationalRiskRegisterRoutes.js";
import excelRoutes from "./excelRoutes.js";
import ObjectiveSettingRoutes from "./objectiveSettingRoutes.js";
import auditSchedulingRoutes from "./auditSchedulingRoutes.js";
import policyRoutes from "./policiesRoutes.js";
import auditExecutionRoutes from "./auditExecutionRoutes.js";
import documentRepositoryRoutes from "./documentRepositoryRoutes.js";
import permitLicenseComplianceRoutes from "./permitLicenseComplianceRoutes.js";
import sheLegalRegisterRoutes from "./sheLegalRegisterRoutes.js";
import legislationRoutes from "./legislationRoutes.js";
import softwareAccessRoutes from "./softwareAccessRoutes.js";
import teamsRoutes from "./teamsRoutes.js";
import notificationRoutes from "./notificationRoutes.js";
import injuryOnDutyFromRoutes from "./injuryOnDutyRoutes.js";
import explosionBombFormRoutes from "./explosionBombFormRoutes.js";
import hazmatFireTechnicalRoutes from "./hazmatFireTechnicalFormRoutes.js";
import occupationalDiseaseFormRoutes from "./occupationalDiseaseTechnicalFormRoutes.js";
import environmentalIncidentsFromRoutes from "./environmentalIncidentalRoutes.js";
import securityIncidentFromRoutes from "./securityIncidentFormRoutes.js";
import vehicleIncidentFormRoutes from "./VehicleIncidentFormRoutes.js";
import infrastructureTechnicalFormRoutes from "./infrastructureTechnicalFormRoutes.js";
import nearMissReportingRoutes from "./nearMissReportingRoutes.js";
import incidentRoutes from "./incidentRoutes.js";
import InvestigationRoutes from "./investigationRoutes.js";
import insuranceClaimRoutes from "./insuranceClaimRecordingRoutes.js";
import insurancePolicyImpactRoutes from "./insurancePolicyImpactRoutes.js";
import operationalRiskIdentificationRoutes from "./operationalRiskIdentificationRoutes.js";
import trainingNeedAnalysisRoutes from "./trainingNeedAnalysisRoutes.js";
import nonComplianceTechnicalRoutes from "./nonComplianceTechnicalFormRoutes.js";
import attendanceRecordingRoutes from "./trainingAttendanceRecordingRoutes.js";
import effectivenessOutcomeRoutes from "./trainingEffectivenessOutcomeRoutes.js";
import trainingScheduleRoutes from "./trainingScheduleRoutes.js";
import competencyAssessmentRoutes from "./competencyAssessmentRoutes.js";
import knowledgeManagementRecordingRoutes from "./knowledgeManagementRecordingRoutes.js";
import stakeholderIdentificationRoutes from "./stakeholderIdentificationRoutes.js";
import surveyDesignRoutes from "./surveyDesignRoutes.js";
import ncrRecordingRoutes from "./ncrRecordingRoutes.js";
import surveyResponseRoutes from "./surveyResponseRoutes.js";
import feedbackCollectionMethod from "./feedbackCollectionMethodRoutes.js";
import nameOfStandardRoutes from "./nameOfStandardRoutes.js";
import stakeholderEngagementPlanRoutes from "./stakeholderEngagementPlanRoutes.js";
import trainingCertificateRoutes from "./trainingCertificateRoutes.js";
import actionTemplateListRoutes from "./actionTemplateListRoutes.js";
import stakeholderActivitySchedulingRoutes from "./stakeholderActivitySchedulingRoutes.js";
import stakeholderActivityRecordingRoutes from "./stakeholderActivityRecordingRoutes.js";
import templateCategoryRoutes from "./templateCategoryRoutes.js";
import labelsRoutes from "./labelsRoutes.js";
import certificatesRoutes from "./certificatesRoutes.js";
import customActionCreationRoutes from "./customActionCreationRoutes.js";
import actionCommentsRoutes from "./actionCommentsRoutes.js";
import actionActivityRoutes from "./actionActivitiesRoutes.js";
import contractorRegistrationRoutes from "./contractorRegistrationRoutes.js";
import contractorRiskAssessmentRoutes from "./contractorRiskAssessmentRoutes.js";
import financialYearRoutes from "./financialYearRoutes.js";
import assessmentLocationRoutes from "./assessmentLocationRoutes.js";
import assessorMethodRoutes from "./assessorMethodRoutes.js";
import contractorMeetingRoutes from "./contractorMeetingRoutes.js";
import contractorMeetingRecordingRoutes from "./contractorMeetingRecordingRoutes.js";
import contractorAppointmentRoutes from "./contractorAppointmentRoutes.js";
import contractorPermitLicenseRoutes from "./contractorPermitLicenseRoutes.js";
import contractorMeetingApprovalRoutes from "./contractorMeetingApprovalRoutes.js";
import contractorAuditSchedulingRoutes from "./contractorAuditSchedulingRoutes.js";
import contractorDocumentRepositoryRoutes from "./contractorDocumentRepositoryRoutes.js";
import contractorAuditProtocolRoutes from "./contractorAuditProtocolRoutes.js";
import contractorTrainingScheduleRoutes from "./contractorTrainingScheduleRoutes.js";
import contractorAttendanceRecordingRoutes from "./contractorAttendanceRecordingRoutes.js";
import contractorRiskRegisterRoutes from "./contractorRiskRegisterRoutes.js";
import contractorNcrRecordingRoutes from "./contractorNcrRecordingRoutes.js";
import contractorQuestionnaireRoutes from "./contractorQuestionnaireRoutes.js";
import contractorPreSiteRoutes from "./contractorPreSiteRoutes.js";
import contractorSafeWorkingRoutes from "./contractorSafeWorkingRoutes.js";
import contractorAgreementsRoutes from "./contractorAgreementsRoutes.js";
import contractorSiteAccessRoutes from "./contractorSiteAccessRoutes.js";
import finalHandoverRoutes from "./finalHandoverRoutes.js";
import ohsFileRequirementRoutes from "./ohsFileRequirementRoutes.js";
import ohsFileAssessmentRoutes from "./ohsFileAssessmentRoutes.js";
import banksRoutes from "./banksRoutes.js";
import materialClassificationRoutes from "./materialClassificationRoutes.js";
import insuranceClaimLogsRoutes from "./insuranceClaimLogsRoutes.js";
import roleOnTheProjectRoutes from "./roleOnTheProjectRoutes.js";
import projectRegistrationRoutes from "./projectRegistrationRoutes.js";
import contractorFormRoutes from "./contractorFormRoutes.js";
import contractorIncidentRoutes from "./contractorIncidentRoutes.js";
import roleHierarchyRoutes from "./roleHierarchyRoutes.js";
import highestQualificationRoutes from "./highestQualificationRoutes.js";
import taskTemplateListRoutes from "./taskTemplateListRoutes.js";
import customTaskCreationRoutes from "./customTaskCreationRoutes.js";
import employeeTypeRoutes from "./employeeTypeRoutes.js";
import disabilityRoutes from "./disabilityRoutes.js";
import sidebarRoutes from "./sideBarRoutes.js";
import equipmentRoutes from "./equipmentRoutes.js";
import locationRoutes from "./locationRoutes.js";
import languageRoutes from "./languageRoutes.js";
import workLocationRoutes from "./workLocationRoutes.js";
import genderRoutes from "./genderRoutes.js";
// import reasonRoutes from "./reasonRoutes.js";
import physicalLocationRoutes from "./physicalLocationRoutes.js";
import SoftwareAccessRequestRoutes from "./softwareAccessRequestRoutes.js";
import FireEquipmentRegisterRoutes from "./fireEquipmentRegisterRoutes.js";
import SOPRoutes from "./SOPRoutes.js";
import wasteManifestRoutes from "./wasteManifestRoutes.js";
import ppeRepositoryRoutes from "./ppeRepositoryRoutes.js";
import FirstAidBoxRoutes from "./firstAidBoxRoutes.js";
import firstAidBoxContentRoutes from "./firstAidBoxContentRoutes.js";
import documentClassificationRoutes from "./documentClassificationRoutes.js";
import FlammableStoreRoutes from "./flammableStoreRoutes.js";
import wasteTypeRoutes from "./wasteTypeRoutes.js";
import reasonForInactiveRoutes from "./reasonForInactiveRoutes.js";
import wasteDisposalMethodRoutes from "./wasteDisposalMethodRoutes.js";
import ppeTypeRoutes from "./ppeTypeRoutes.js";
import opportunityManagementRoutes from "./opportunityManagementRoutes.js";
import currencyRoutes from "./currencyRoutes.js";
import assetTypeRoutes from "./assetTypeRoutes.js";
import assetRoutes from "./assetRoutes.js";
import purposeOfTrainingRoutes from "./purposeOfTrainingRoutes.js";
import auditTypeRoutes from "./auditTypeRoutes.js";
import typeOfServiceRoutes from "./typeOfServiceRoutes.js";
import fileClassificationRoutes from "./fileClassificationRoutes.js";
import inspectionLocationRoutes from "./inspectionLocationRoutes.js";
import bestPracticeRoutes from "./bestPracticeRoutes.js";
import stakeholderClassificationRoutes from "./stakeholderClassificationRoutes.js";
import severityRoutes from "./severityRoutes.js";
import engagementMethodRoutes from "./engagementMethodRoutes.js";
import engagementLevelsRoutes from "./engagementLevelsRoutes.js";
import incidentRoleRoutes from "./incidentRoleRoutes.js";
import incidentLocationRoutes from "./incidentLocationRoutes.js";
import feedbackContextRoutes from "./feedbackContextRoutes.js";
import regulatorRoutes from "./regulatorRoutes.js";
import securityIncidentTypeRoutes from "./securityIncidentTypeRoutes.js";
import qualityIncidentTypeRoutes from "./qualityIncidentTypeRoutes.js";
import occupationalDiseaseRoutes from "./occupationalDiseaseRoutes.js";
import occupationalDiseaseTypeRoutes from "./occupationalDiseaseTypeRoutes.js";
import defectTypeRoutes from "./defectTypeRoutes.js";
import defectDetectionMethodRoutes from "./defectDetectionMethodRoutes.js";
import wasteDescriptionRoutes from "./wasteDescriptionRoutes.js";
import complaintCategoryRoutes from "./complaintCategoryRoutes.js";
import shiftInformationRoutes from "./shiftInformationRoutes.js";
import deviationCategoryRoutes from "./deviationCategoryRoutes.js";
import illnessTypeRoutes from "./illnessTypeRoutes.js";
import policeStationRoutes from "./policeStationRoutes.js";
import DDRMRoutes from "./ddrmRoutes.js";
import RepositoryRouter from "./repositoryRoutes.js";
import DocumentCategoriesRoutes from "./documentCategoriesRoutes.js";
import DocumentCreationRoutes from "./documentCreationRoutes.js";
import BcpRequirementAnalysisRoutes from "./bcpRequirementAnalysisRoutes.js";
import BcpManagementRoutes from "./bcpManagementRoutes.js";
import BcpTestingRoutes from "./bcpTestingRoutes.js";
import activityLocationRoutes from "./activityLocationRoutes.js";
import crisisLocationRoutes from "./crisisLocationRoutes.js";
import testLocationRoutes from "./testLocationRoutes.js";
import sopCategoryRoutes from "./sopCategoryRoutes.js";
import crisisTypeRoutes from "./crisisTypeRoutes.js";
import commandCenterLocationRoutes from "./commandCenterLocationRoutes.js";
import communicationMethodRoutes from "./communicationMethodRoutes.js";
import affectedAreaRoutes from "./affectedAreaRoutes.js";
import criticalSystemAffectedRoutes from "./criticalSystemAffectedRoutes.js";
import CrisisManagementRoutes from "./crisisManagementRoutes.js";
import retentionPolicySettingRoutes from "./retentionPolicySettingRoutes.js";
import auditLogRoutes from "./auditLogRoutes.js";
import raceRoutes from "./raceRoutes.js";
import relationRoutes from "./relationRoutes.js";
import hospitalRoutes from "./hospitalRoutes.js";
import regulatoryBodyRoutes from "./regulatoryBodyRoutes.js";
import vehiclePartsRoutes from "./vehiclePartsRoutes.js";
import newLocationRoutes from "./newLocationRoutes.js";
import competenciesAssessedRoutes from "./competenciesAssessedRoutes.js";
import businessProcessesRoutes from "./businessProcessesRoutes.js";
import trainingDisclaimerRoutes from "./trainingDisclaimerRoutes.js";
import incidentPpeRoutes from "./incidentPpeRoutes.js";
import bodyPartRoutes from "./bodyPartRoutes.js";
import ContractorInvestigationRoutes from "./contractorInvestigationRoutes.js";
import FireEquipmentMaintenanceInspectionRoutes from "./fireEquipmentMaintenanceInspectionRoutes.js";
import collectionSiteRoutes from "./collectionSiteRoutes.js";
import disposalSiteRoutes from "./disposalSiteRoutes.js";
import dashboardRoutes from "./dashboardRoutes.js";
import announcementRoutes from "./announcementRoutes.js";
import activityLogRoutes from "./ActivityLogRoutes.js";
import processesRoutes from "./processesRoutes.js";
import mainProcessRoutes from "./mainProcessRoutes.js";
import controlTypeRoutes from "./controlTypeRoutes.js";
import categoryRoutes from "./categoryRoutes.js";

const routes = Router();

routes.use("/sidebar", sidebarRoutes);

routes.use("/users", usersRoutes);

routes.use("/organization", organizationRoutes);

routes.use("/departments", departmentRoutes);

routes.use("/incidentCategory", incidentCategoryRoutes);

routes.use("/responsibility", responsibilityRoutes);

routes.use("/issuingAuthority", issuingAuthorityRoutes);

routes.use("/permitLicense", permitLicenseRoutes);

routes.use("/documentType", documentTypeRoutes);

routes.use("/focusArea", focusAreaRoutes);

routes.use("/auditCategory", auditCategoryRoutes);

routes.use("/skill", SkillRoutes);

routes.use("/license", licenseRoutes);

routes.use("/appointmentType", appointmentTypeRoutes);

routes.use("/parentObjective", parentObjectiveRoutes);

routes.use("/measurementMetric", measurementMetricRoutes);

routes.use("/categoryType", categoryTypeRoutes);

routes.use("/auditTemplate", auditTemplateRoutes);

routes.use("/roles", rolesRoutes);

routes.use("/hseAppointment", hseAppointmentRoutes);

routes.use("/meeting", meetingRoutes);

routes.use("/meetingRecording", meetingRecordingRoutes);

routes.use("/meeting-approval", meetingApprovalRoutes);

routes.use("/strategicRisk", strategicRiskRoutes);

routes.use("/strategicRiskIdentification", strategicRiskIdentificationRoutes);

routes.use("/ObjectiveSetting", ObjectiveSettingRoutes);

routes.use("/auditScheduling", auditSchedulingRoutes);

routes.use("/tacticalRisk", tacticalRiskRoutes);

routes.use("/tacticalRiskIdentification", tacticalRiskIdentificationRoutes);

routes.use("/operationalRisk", operationalRiskRegisterRoutes);

routes.use("/excel", excelRoutes);

routes.use("/policy", policyRoutes);

routes.use("/auditExecution", auditExecutionRoutes);

routes.use("/documentRepository", documentRepositoryRoutes);

routes.use("/permitLicenseCompliance", permitLicenseComplianceRoutes);

routes.use("/sheLegalRegister", sheLegalRegisterRoutes);

routes.use("/legislation", legislationRoutes);

routes.use("/softwareAccess", softwareAccessRoutes);

routes.use("/teams", teamsRoutes);

routes.use("/notification", notificationRoutes);

routes.use("/injuryOnDutyForm", injuryOnDutyFromRoutes);

//TODO - Check it
routes.use("/explosionBombForm", explosionBombFormRoutes);

routes.use("/hazmatFireTechnical", hazmatFireTechnicalRoutes);

routes.use("/occupationalDiseaseForm", occupationalDiseaseFormRoutes);

routes.use("/environmentalIncidentsForm", environmentalIncidentsFromRoutes);

routes.use("/securityIncidentForm", securityIncidentFromRoutes);

// TODO - Check it
routes.use("/vehicleIncidentForm", vehicleIncidentFormRoutes);

routes.use("/infrastructureTechnicalForm", infrastructureTechnicalFormRoutes);

routes.use("/nearMissReporting", nearMissReportingRoutes);

routes.use("/incident", incidentRoutes);

// TODO - Check it
routes.use("/investigation", InvestigationRoutes);

routes.use("/insuranceClaim", insuranceClaimRoutes);

routes.use("/insurancePolicyImpact", insurancePolicyImpactRoutes);

routes.use(
  "/operationalRiskIdentification",
  operationalRiskIdentificationRoutes
);

routes.use("/trainingNeedAnalysis", trainingNeedAnalysisRoutes);

routes.use("/trainingSchedule", trainingScheduleRoutes);

routes.use("/nonComplianceTechnicalForm", nonComplianceTechnicalRoutes);

routes.use("/attendanceRecording", attendanceRecordingRoutes);

routes.use("/effectivenessOutcome", effectivenessOutcomeRoutes);

routes.use("/competencyAssessment", competencyAssessmentRoutes);

routes.use("/knowledgeManagementRecording", knowledgeManagementRecordingRoutes);

routes.use("/surveyDesign", surveyDesignRoutes);

routes.use("/stakeholderIdentification", stakeholderIdentificationRoutes);

routes.use("/ncrRecording", ncrRecordingRoutes);

// Todo - Check it
routes.use("/surveyResponse", surveyResponseRoutes);

routes.use("/feedbackCollection", feedbackCollectionMethod);

routes.use("/nameOfStandard", nameOfStandardRoutes);

routes.use("/stakeholderEngagementPlan", stakeholderEngagementPlanRoutes);

routes.use("/trainingCertificate", trainingCertificateRoutes);

routes.use("/actionTemplateList", actionTemplateListRoutes);

// Todo - Check it
routes.use(
  "/stakeholderActivityScheduling",
  stakeholderActivitySchedulingRoutes
);

// Todo - Check it
routes.use("/stakeholderActivityRecording", stakeholderActivityRecordingRoutes);

// Todo - Add `table_name` : `template_category` in db
routes.use("/templateCategory", templateCategoryRoutes);

routes.use("/labels", labelsRoutes);

routes.use("/certificates", certificatesRoutes);

routes.use("/customActionCreation", customActionCreationRoutes);

routes.use("/actionComments", actionCommentsRoutes);

routes.use("/actionActivity", actionActivityRoutes);

routes.use("/contractorRegistration", contractorRegistrationRoutes);

routes.use("/contractorRiskAssessment", contractorRiskAssessmentRoutes);

routes.use("/financialYear", financialYearRoutes);

routes.use("/assessmentLocation", assessmentLocationRoutes);

routes.use("/assessorMethod", assessorMethodRoutes);

routes.use("/contractorMeeting", contractorMeetingRoutes);

routes.use("/contractorMeetingRecording", contractorMeetingRecordingRoutes);

routes.use("/contractorMeetingApproval", contractorMeetingApprovalRoutes);

routes.use("/contractorAppointment", contractorAppointmentRoutes);

routes.use("/contractorPermitLicense", contractorPermitLicenseRoutes);

routes.use("/contractorAuditScheduling", contractorAuditSchedulingRoutes);

routes.use("/contractorAuditProtocol", contractorAuditProtocolRoutes);

routes.use("/contractorDocumentRepository", contractorDocumentRepositoryRoutes);

routes.use("/contractorTrainingSchedule", contractorTrainingScheduleRoutes);

routes.use(
  "/contractorAttendanceRecording",
  contractorAttendanceRecordingRoutes
);

routes.use("/contractorRiskRegister", contractorRiskRegisterRoutes);

routes.use("/contractorNcrRecording", contractorNcrRecordingRoutes);
routes.use("/contractorRiskRegister", contractorRiskRegisterRoutes);

routes.use("/contractorNcrRecording", contractorNcrRecordingRoutes);

routes.use("/contractorQuestionnaire", contractorQuestionnaireRoutes);

// Todo - Check it
routes.use("/contractorPreSite", contractorPreSiteRoutes);

routes.use("/contractorSafeWorking", contractorSafeWorkingRoutes);

routes.use("/contractorAgreements", contractorAgreementsRoutes);

routes.use("/contractorSiteAccess", contractorSiteAccessRoutes);

// Todo - No sideBarPermissionCheck
routes.use("/finalHandover", finalHandoverRoutes);

// Todo - No sideBarPermissionCheck
routes.use("/ohsFileRequirement", ohsFileRequirementRoutes);

// Todo - No sideBarPermissionCheck
routes.use("/ohsFileAssessment", ohsFileAssessmentRoutes);

routes.use("/banks", banksRoutes);

// Todo - check it
routes.use("/materialClassification", materialClassificationRoutes);

// Todo - No sideBarPermissionCheck
routes.use("/insuranceClaimLogs", insuranceClaimLogsRoutes);

routes.use("/roleOnTheProject", roleOnTheProjectRoutes);

// Todo - No sideBarPermissionCheck
routes.use("/projectRegistration", projectRegistrationRoutes);

routes.use("/contractorForm", contractorFormRoutes);

routes.use("/contractorIncident", contractorIncidentRoutes);

routes.use("/roleHierarchy", roleHierarchyRoutes);

routes.use("/highestQualification", highestQualificationRoutes);

routes.use("/taskTemplateList", taskTemplateListRoutes);

// Todo - Add `table_name` : `custom_task_creation` in db
routes.use("/customTaskCreation", customTaskCreationRoutes);

// not in use this employee type
routes.use("/employeeType", employeeTypeRoutes);

routes.use("/disability", disabilityRoutes);

routes.use("/equipment", equipmentRoutes);

// Todo - Check it
routes.use("/location", locationRoutes);

routes.use("/gender", genderRoutes);

routes.use("/language", languageRoutes);

routes.use("/workLocation", workLocationRoutes);

routes.use("/physicalLocation", physicalLocationRoutes);

routes.use("/softwareAccessRequest", SoftwareAccessRequestRoutes);

routes.use("/FireEquipmentRegister", FireEquipmentRegisterRoutes);
routes.use(
  "/FireEquipmentMaintenanceInspection",
  FireEquipmentMaintenanceInspectionRoutes
);

routes.use("/wasteManifest", wasteManifestRoutes);

// Todo - Check it
routes.use("/SOP", SOPRoutes);

// Todo - Check it
routes.use("/wasteType", wasteTypeRoutes);

routes.use("/ppeRepository", ppeRepositoryRoutes);

routes.use("/firstAidBox", FirstAidBoxRoutes);

// Todo - Check it
routes.use("/firstAidBoxContent", firstAidBoxContentRoutes);

// Todo - Check it
routes.use("/flammableStore", FlammableStoreRoutes);

routes.use("/documentClassification", documentClassificationRoutes);

// Todo - Check it
routes.use("/wasteDisposalMethod", wasteDisposalMethodRoutes);

// Todo - Add `table_name` : `reason_for_inactive` in db
routes.use("/reasonForInactive", reasonForInactiveRoutes);

// ! Repeated Routes
// routes.use('/firstAidBoxContent', firstAidBoxContentRoutes);

// Todo - Check it
routes.use("/ppeType", ppeTypeRoutes);

// Todo - No sideBarPermissionCheck
routes.use("/opportunityManagement", opportunityManagementRoutes);

// Todo - Check it
routes.use("/currency", currencyRoutes);

// Todo - Check it
routes.use("/assetType", assetTypeRoutes);

// Todo - No sideBarPermissionCheck
routes.use("/asset", assetRoutes);

// Todo - Check it
routes.use("/purposeOfTraining", purposeOfTrainingRoutes);

// Todo - Check it
routes.use("/auditType", auditTypeRoutes);

// Todo - Check it
routes.use("/typeOfService", typeOfServiceRoutes);

// Todo - Check it
routes.use("/fileClassification", fileClassificationRoutes);

routes.use("/inspectionLocation", inspectionLocationRoutes);

routes.use("/bestPractice", bestPracticeRoutes);

// Todo - Check it
routes.use("/stakeholderClassification", stakeholderClassificationRoutes);

// Todo - Check it
routes.use("/severity", severityRoutes);

// Todo - Check it
routes.use("/engagementMethod", engagementMethodRoutes);

// Todo - Check it
routes.use("/engagementLevels", engagementLevelsRoutes);

// Todo - Check it
routes.use("/incidentRole", incidentRoleRoutes);

// Todo - Check it
routes.use("/incidentLocation", incidentLocationRoutes);

// Todo - Check it
routes.use("/feedbackContext", feedbackContextRoutes);
// Todo - Check it
routes.use("/regulator", regulatorRoutes);
// Todo - Check it
routes.use("/securityIncidentType", securityIncidentTypeRoutes);
// Todo - Check it
routes.use("/qualityIncidentType", qualityIncidentTypeRoutes);
// Todo - Check it
routes.use("/occupationalDisease", occupationalDiseaseRoutes);
// Todo - Check it
routes.use("/occupationalDiseaseType", occupationalDiseaseTypeRoutes);
// Todo - no sidebar permission check
routes.use("/policestation", policeStationRoutes);

// Todo - Check it
routes.use("/illnessType", illnessTypeRoutes);

routes.use("/defectType", defectTypeRoutes);

routes.use("/defectDetectionMethod", defectDetectionMethodRoutes);

routes.use("/wasteDescription", wasteDescriptionRoutes);

// Todo - Check it
routes.use("/complaintCategory", complaintCategoryRoutes);

routes.use("/shiftInformation", shiftInformationRoutes);

routes.use("/deviationCategory", deviationCategoryRoutes);

// Todo - Check it
routes.use("/illnessType", illnessTypeRoutes);

// Todo - Add `table_name` : `ddrm` in db
routes.use("/assignedDocument", DDRMRoutes);

// Todo - Check it
routes.use("/repository", RepositoryRouter);

// Todo - Check it
routes.use("/documentCategories", DocumentCategoriesRoutes);

// Todo - Check it
routes.use("/documentCreation", DocumentCreationRoutes);

// Todo - Check it
routes.use("/bcpRequirementAnalysis", BcpRequirementAnalysisRoutes);
routes.use("/bcpManagement", BcpManagementRoutes);
routes.use("/bcpTesting", BcpTestingRoutes);

routes.use("/activityLocation", activityLocationRoutes);

routes.use("/testLocation", testLocationRoutes);

routes.use("/crisisLocation", crisisLocationRoutes);

routes.use("/sopCategory", sopCategoryRoutes);

routes.use("/crisisType", crisisTypeRoutes);

routes.use("/commandCenterLocation", commandCenterLocationRoutes);

routes.use("/communicationMethod", communicationMethodRoutes);

routes.use("/affectedArea", affectedAreaRoutes);

routes.use("/criticalSystemAffected", criticalSystemAffectedRoutes);

routes.use("/crisisManagement", CrisisManagementRoutes);

routes.use("/retentionPolicySetting", retentionPolicySettingRoutes);

routes.use("/auditLog", auditLogRoutes);

routes.use("/race", raceRoutes);

routes.use("/relation", relationRoutes);

routes.use("/hospital", hospitalRoutes);

routes.use("/regulatoryBody", regulatoryBodyRoutes);

routes.use("/trainingDisclaimer", trainingDisclaimerRoutes);

routes.use("/vehicleParts", vehiclePartsRoutes);

routes.use("/newLocation", newLocationRoutes);
routes.use("/competenciesAssessed", competenciesAssessedRoutes);

routes.use("/businessProcesses", businessProcessesRoutes);

routes.use("/incidentPpe", incidentPpeRoutes);

routes.use("/bodyPart", bodyPartRoutes);
routes.use("/contractorInvestigation", ContractorInvestigationRoutes);

routes.use("/collectionSite", collectionSiteRoutes);
routes.use("/disposalSite", disposalSiteRoutes);
routes.use("/dashboard", dashboardRoutes);
routes.use("/announcement", announcementRoutes);
routes.use("/activityLog", activityLogRoutes);
routes.use("/processes", processesRoutes);

routes.use("/mainProcess", mainProcessRoutes);
routes.use("/controlType" , controlTypeRoutes)
routes.use("/category" , categoryRoutes)
export default routes;
