import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateWasteDescription, deleteWasteDescription, viewWasteDescription } from "../controller/wasteDescriptionController.js";

/**
 * @swagger
 * tags:
 *   name:  waste description
 *   description: API operations for managing  waste description
 */
const wasteDescriptionRoutes = Router();

/**
 * @swagger
 * /api/wasteDescription/create-update-waste-description:
 *   post:
 *     summary: Create or update a  waste description
 *     tags: [ waste description]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
wasteDescriptionRoutes.post(
  "/create-update-waste-description",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 416 , "waste_description")(req, res, next);
  },
  controllerWrapper(createUpdateWasteDescription)
);

/**
 * @swagger
 * /api/wasteDescription/get-waste-description:
 *   get:
 *     summary: Get all records of  waste description
 *     tags: [ waste description]
 */
wasteDescriptionRoutes.get(
  "/get-waste-description",
  verifyToken,
  sideBarPermissionCheck("view", 416, "waste_description"),
  controllerWrapper(viewWasteDescription)
);

/**
 * @swagger
 * /api/wasteDescription/get-waste-description/{id}:
 *   get:
 *     summary: Get a specific record of  waste description
 *     tags: [ waste description]
 */
wasteDescriptionRoutes.get(
  "/get-waste-description/:id",
  verifyToken,
  sideBarPermissionCheck("view", 416, "waste_description"),
  controllerWrapper(viewWasteDescription)
);

/**
 * @swagger
 * /api/wasteDescription/delete-waste-description/{id}:
 *   delete:
 *     summary: Delete a specific record of  waste description
 *     tags: [ waste description]
 */
wasteDescriptionRoutes.delete(
  "/delete-waste-description/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 416, "waste_description"),
  controllerWrapper(deleteWasteDescription)
);

export default wasteDescriptionRoutes;