import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateWorkLocation, deleteWorkLocation, viewWorkLocation } from "../controller/workLocationController.js";

/**
 * @swagger
 * tags:
 *   name:  work location
 *   description: API operations for managing  work location
 */
const workLocationRoutes = Router();

/**
 * @swagger
 * /api/workLocation/create-update-work-location:
 *   post:
 *     summary: Create or update a  work location
 *     tags: [ work location]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
workLocationRoutes.post(
  "/create-update-work-location",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 370 , "work_location")(req, res, next);
  },
  controllerWrapper(createUpdateWorkLocation)
);

/**
 * @swagger
 * /api/workLocation/get-work-location:
 *   get:
 *     summary: Get all records of  work location
 *     tags: [ work location]
 */
workLocationRoutes.get(
  "/get-work-location",
  verifyToken,
  sideBarPermissionCheck("view", 370, "work_location"),
  controllerWrapper(viewWorkLocation)
);

/**
 * @swagger
 * /api/workLocation/get-work-location/{id}:
 *   get:
 *     summary: Get a specific record of  work location
 *     tags: [ work location]
 */
workLocationRoutes.get(
  "/get-work-location/:id",
  verifyToken,
  sideBarPermissionCheck("view", 370, "work_location"),
  controllerWrapper(viewWorkLocation)
);

/**
 * @swagger
 * /api/workLocation/delete-work-location/{id}:
 *   delete:
 *     summary: Delete a specific record of  work location
 *     tags: [ work location]
 */
workLocationRoutes.delete(
  "/delete-work-location/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 370, "work_location"),
  controllerWrapper(deleteWorkLocation)
);

export default workLocationRoutes;