import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import CustomActionCreation from "./CustomActionCreationSchema.js";
import Department from "./DepartmentSchema.js";

const ActionActivities = sequelize.define(
  "ActionActivities",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    custom_action_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: CustomActionCreation,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },

    type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    estimated_time: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    action: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },

    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
  },
  {
    tableName: "action_activities",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ActionActivities.belongsTo(User, { as: "creator", foreignKey: "created_by" });
ActionActivities.belongsTo(User, { as: "updater", foreignKey: "updated_by" });
ActionActivities.belongsTo(Organization, {
  as: "org",
  foreignKey: "organization",
});
ActionActivities.belongsTo(Department, {
  as: "dep",
  foreignKey: "department",
});
ActionActivities.belongsTo(CustomActionCreation, {
  as: "custom",
  foreignKey: "custom_action_id",
});

export default ActionActivities;
