import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import BcpManagement from "./BcpManagementSchema.js";

const BcpManagementComment = sequelize.define(
  "BcpManagementComment",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    bcp_management_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: BcpManagement,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM("approved", "rejected"),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
    },
  },
  {
    tableName: "bcp_management_comment",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

BcpManagementComment.belongsTo(BcpManagement, {
  foreignKey: "bcp_management_id",
  as: "bcpManagement",
});

BcpManagementComment.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

BcpManagementComment.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

// console.log(await BcpManagementComment.sync({ alter: true }));

export default BcpManagementComment;
