import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js"; // Adjust imports according to your project
import db from "../db-config.js";

// Define the BodyPart model
const BodyPart = sequelize.define(
  "body_part",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    label: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    parent_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: "body_part", // Table name
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "CASCADE",
    },
    is_static: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "body_part",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await BodyPart.sync({ alter: true }));
export default BodyPart;

// import data from "../disablities.json" assert { type: "json" };
// import { uniqueIdGenerator } from "../helper/general.js";
// console.log("data: ", data);

// async function insertParentChildData(data, parentId = null, db) {
//   for (const item of data) {
//     // Insert the current item into the database
//     const [result] = await db.query(`INSERT INTO illness_type (name, parent, organization, created_by) VALUES (?, ?, ?, ?)`, [
//       item.name,
//       parentId,
//       0,
//       1
//     ]);
//     const insertedId = result.insertId;
//     // If the item has children, recursively insert them
//     if (item.children && item.children.length > 0) {
//       await insertParentChildData(item.children, insertedId, db);
//     }
//   }
//   return "true";
// }

// async function insertParentChildData(data, parentId = null, db, id) {
//   for (const item of data) {
//     const unique_id = await uniqueIdGenerator(14, null, "Disability", "disability", "unique_id", "unique_id");
//     // Insert the current item into the database
//     const [result] = await db.query(
//       `INSERT INTO disability (name, parent, organization, created_by, unique_id) VALUES (?, ?, ?, ?, ?)`,
//       [item.name, parentId, id, 1, unique_id]
//     );
//     const insertedId = result.insertId;
//     // If the item has children, recursively insert them
//     if (item.children && item.children.length > 0) {
//       await insertParentChildData(item.children, insertedId, db, id);
//     }
//   }
// }

// async function insertData(data, db) {
//   const [organizations] = await db.query(`SELECT id FROM organization WHERE deleted = 0`);

//   const organizationIds = JSON.stringify(organizations.map((org) => org.id));
//   // console.log("organizationIds: ", organizationIds);
//   await insertParentChildData(data, null, db, organizationIds);
//   // for (const organization of organizations) {
//   //   const { id } = organization;
//   //   //     // for direct data import
//   //   for (let i = 0; i < data.length; i++) {
//   //     const item = data[i];
//   //     const parentId = data[i].parent_id;
//   //     await db.query(
//   //       `INSERT INTO incident_location (name, parent, organization, created_by) VALUES (?, ?, ?, ?)`,
//   //       [item.name, parentId, id, 1]
//   //     );
//   //   }
//   // }
//   return "true";
// }

// console.log(await insertData(data, db));
