import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js"; // Adjust imports according to your project
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

// Define the BusinessProcesses model
const BusinessProcesses = sequelize.define(
  "business_processes",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.TEXT("long"),
      allowNull: true,

      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    is_static:{
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "business_processes",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations
BusinessProcesses.belongsTo(Department, {
  as: "departmentDetails",
  foreignKey: "department",
});
// BusinessProcesses.belongsTo(Organization, {
//   as: "organizationDetails",
//   foreignKey: "organization",
// });
BusinessProcesses.belongsTo(User, {
  as: "creator",
  foreignKey: "created_by",
});
BusinessProcesses.belongsTo(User, {
  as: "updater",
  foreignKey: "updated_by",
});
// console.log(await BusinessProcesses.sync({ alter: true }));
export default BusinessProcesses;
