import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import AssessmentLocation from "./AssessmentLocationSchema.js";
import AccessorMethod from "./AssessorMethodSchema.js";
import User from "./UserSchema.js";
import Role from "./RoleSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import Location from "./LocationSchema.js";

const CompetencyAssessment = sequelize.define(
  "CompetencyAssessment",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    assessment_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    schedule_training: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    assessment_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    assessment_location: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Location,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    assessment_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    assessment_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    assessor_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    assessor_duration: {
      type: DataTypes.STRING(10),
      allowNull: true,
    },
    assessor_method: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: AccessorMethod,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    assessor_name: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    competencies_assessed: {
      type: DataTypes.STRING(255),
      allowNull: true,
      // reference : competencies_assessed table (now its id of int type)
    },
    individual_assessment: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    job_role: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Role,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "competency_assessment",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

CompetencyAssessment.belongsTo(Location, {
  as: "assessmentLocation",
  foreignKey: "assessment_location",
});
CompetencyAssessment.belongsTo(AccessorMethod, {
  as: "assessorMethod",
  foreignKey: "assessor_method",
});
CompetencyAssessment.belongsTo(User, {
  as: "assessor",
  foreignKey: "assessor_name",
});
CompetencyAssessment.belongsTo(Role, {
  as: "jobRole",
  foreignKey: "job_role",
});
CompetencyAssessment.belongsTo(Organization, {
  as: "organizationDetails",
  foreignKey: "organization",
});
CompetencyAssessment.belongsTo(Department, {
  as: "departmentDetails",
  foreignKey: "department",
});
CompetencyAssessment.belongsTo(User, {
  as: "creator",
  foreignKey: "created_by",
});
CompetencyAssessment.belongsTo(User, {
  as: "updater",
  foreignKey: "updated_by",
});

// console.log(await CompetencyAssessment.sync({alter : true}))

export default CompetencyAssessment;
