import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";
import NameOfStandard from "./NameOfStandardSchema.js";
import Department from "./DepartmentSchema.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";

const ContractorNCR = sequelize.define(
  "ContractorNCR",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    ncr_title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    reference_no: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    origin_ncr: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    specify_origin_ncr: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    specify_type_ncr: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    type_ncr: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    raised_by: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    raised_by_email: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    raised_by_surname: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    raised_by_project: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },

    ncr_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    type_of_work: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    immediate_action_taken: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    legal_non_compliance: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    system_non_conformance: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    customer_non_compliance: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    name_of_legislation: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    name_of_standard: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: NameOfStandard,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    customer_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    provision_of_the_requirement: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    standard_clause_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    contravened_contract_clause: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ncr_categories: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    classification: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    raised_type: {
      type: DataTypes.INTEGER,
      allowNull: true,
      // references: {
      //   model: User,
      //   key: "id",
      // },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    internal_raised_business: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    internal_raised_against_business: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    internal_raised_against_department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    internal_name_of_site: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    internal_location: {
      type: DataTypes.STRING(255),
      allowNull: true,
      // reference to location now its id of int type
    },
    internal_responsible_person: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    internal_employee_no: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    internal_date_raised: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    external_raised_person: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    external_contact_details: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    external_date_raised: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    external_due_date_resolve_ncr: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    external_responsible_person: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    corrective_action_title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    corrective_action_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    corrective_responsible_department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    corrective_responsible_person: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    corrective_start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    corrective_due_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    corrective_action_progress: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    corrective_status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    preventative_action_title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    preventative_action_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    preventative_responsible_department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    preventative_responsible_person: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    preventative_start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    preventative_due_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    preventative_action_progress: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    preventative_status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    root_cause: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    human_resource_requirements: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    technological_resources: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    type_of_resource: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    amount: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    necessary_corrective: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    new_risk: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    problem_been_removed: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    stop_certificate_used: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    stop_certificate_id: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    requirements_contravened: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    condition_of_stop_certificate: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    recipient_user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    recipient_role: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    recipient_employee_number: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    recipient_date_received: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    issuer_user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    issuer_designation: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    issuer_contact_number: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    issuer_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    issuer_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    date_lifted: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    compliance_to_mitigation: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    lifting_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    signature_type: {
      type: DataTypes.ENUM("Electronic", "Manual"),
      allowNull: false,
      defaultValue: "Manual",
    },
    stop_certificate_ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      // reference from repository table
    },
    ncr_report_ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      // reference from repository table
    },
    corrective_action_been_raised: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    preventative_action_been_raised: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "contractor_ncr_recording",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations for ContractorNCR
ContractorNCR.belongsTo(Organization, {
  foreignKey: "organization",
  as: "organizationReference",
});

ContractorNCR.belongsTo(NameOfStandard, {
  foreignKey: "name_of_standard",
  as: "standard",
});

ContractorNCR.belongsTo(Organization, {
  foreignKey: "internal_raised_business",
  as: "internalRaisedBusiness",
});

ContractorNCR.belongsTo(Organization, {
  foreignKey: "internal_raised_against_business",
  as: "internalRaisedAgainstBusiness",
});

ContractorNCR.belongsTo(Department, {
  foreignKey: "internal_raised_against_department",
  as: "internalRaisedAgainstDepartment",
});

ContractorNCR.belongsTo(User, {
  foreignKey: "internal_responsible_person",
  as: "internalResponsiblePerson",
});

ContractorNCR.belongsTo(Department, {
  foreignKey: "corrective_responsible_department",
  as: "correctiveResponsibleDepartment",
});

ContractorNCR.belongsTo(User, {
  foreignKey: "corrective_responsible_person",
  as: "correctiveResponsiblePerson",
});

ContractorNCR.belongsTo(Department, {
  foreignKey: "preventative_responsible_department",
  as: "preventativeResponsibleDepartment",
});

ContractorNCR.belongsTo(User, {
  foreignKey: "preventative_responsible_person",
  as: "preventativeResponsiblePerson",
});

ContractorNCR.belongsTo(User, {
  foreignKey: "created_by",
  as: "creator",
});

ContractorNCR.belongsTo(User, {
  foreignKey: "updated_by",
  as: "updater",
});

// console.log(await ContractorNCR.sync({ alter: true }));
export default ContractorNCR;
