import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import TaskTemplateList from "./TaskTemplateListSchema.js";
import TemplateCategory from "./TemplateCategorySchema.js";
import Labels from "./LabelsSchema.js";
import Role from "./RoleSchema.js";
import Skill from "./SkillSchema.js";
import Certificates from "./CertificatesSchema.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import Category from "./CategorySchema.js";

const CustomTaskCreation = sequelize.define(
  "CustomTaskCreation",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    template: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: TaskTemplateList,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    task_title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    task_type: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    module: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    sub_module: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    record_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    tag: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Category,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    label: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Labels,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    estimated_time: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    task_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    successor_task_template: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    category: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Category,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    sub_category: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Category,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    predecessor_task_template: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    role: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Role,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    skill: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Skill,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    certificate: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Certificates,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    responsible_person: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    collaborators: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    end_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "To-Do",
    },
    priority: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    attachment: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    task_budget: {
      type: DataTypes.BIGINT,
      allowNull: true,
    },
    human_resource_requirements: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    technological_resources: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    type: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "stop",
    },
    values: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    type_of_resource: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    amount: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,

    tableName: "custom_task_creation",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// CustomTaskCreation.belongsTo(TaskTemplateList, {
//   foreignKey: "template",
//   as: "ActionTemplate",
// });
// CustomTaskCreation.belongsTo(TemplateCategory, {
//   foreignKey: "tag",
//   as: "TagCategory",
// });
// CustomTaskCreation.belongsTo(Labels, { foreignKey: "label", as: "Label" });
// CustomTaskCreation.belongsTo(TemplateCategory, {
//   foreignKey: "category",
//   as: "Category",
// });
// CustomTaskCreation.belongsTo(TemplateCategory, {
//   foreignKey: "sub_category",
//   as: "SubCategory",
// });
// CustomTaskCreation.belongsTo(Role, { foreignKey: "role", as: "Role" });
// CustomTaskCreation.belongsTo(Skill, { foreignKey: "skill", as: "Skill" });
// CustomTaskCreation.belongsTo(Certificates, {
//   foreignKey: "certificate",
//   as: "Certificate",
// });
// CustomTaskCreation.belongsTo(User, {
//   foreignKey: "responsible_person",
//   as: "ResponsiblePerson",
// });
// CustomTaskCreation.belongsTo(Organization, {
//   foreignKey: "organization",
//   as: "Organization",
// });
// CustomTaskCreation.belongsTo(Department, {
//   foreignKey: "department",
//   as: "Department",
// });
// CustomTaskCreation.belongsTo(User, {
//   foreignKey: "created_by",
//   as: "CreatedByUser",
// });
// CustomTaskCreation.belongsTo(User, {
//   foreignKey: "updated_by",
//   as: "UpdatedByUser",
// });
// console.log(await CustomTaskCreation.sync({ alter: true }));
export default CustomTaskCreation;
