import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import { EndFields } from "../constants/constants.js";


const DocumentCategories = sequelize.define(
    'document_categories',
    {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        name: {
            type: DataTypes.STRING,
            allowNull: true
        },
        description : {
            type: DataTypes.TEXT("long"),
            allowNull: true
        },
        unique_id: {
            type: DataTypes.STRING(255),
            allowNull: true,
        },
        ...EndFields
    },{
        timestamps: false,
        tableName : 'document_categories',
        charset: "utf8mb4",
        collate: "utf8mb4_general_ci",
    }
)
// console.log(await DocumentCategories.sync({ alter: true }));
export default DocumentCategories