import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";

const ObjectiveSetting = sequelize.define(
  "ObjectiveSetting",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    // parent_objective: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // parent_objective_name: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    source: {
      type: DataTypes.STRING(255),
    },
    legislation_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    provision_of_the_requirement: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    level_of_legislation: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    risk_type: {
      type: DataTypes.ENUM(
        "strategic_risk_identification",
        "tactical_risk_identification",
        "operational_risk_identification",
        "none"
      ),
      allowNull: true,
      defaultValue: "none",
    },
    risk: {
      type: DataTypes.INTEGER,
    },
    legal: {
      type: DataTypes.INTEGER,
    },
    associated_risks_register: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    associated_risks: {
      type: DataTypes.TEXT({ charset: "utf8mb4", collate: "utf8mb4_bin" }),
      allowNull: true,
    },
    objective_target_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    objective_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    objective_owner: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    date_generated: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    objective_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    human_resource_requirements: {
      type: DataTypes.TEXT({ charset: "utf8mb4", collate: "utf8mb4_bin" }),
      allowNull: true,
    },
    technological_resources: {
      type: DataTypes.TEXT({ charset: "utf8mb4", collate: "utf8mb4_bin" }),
      allowNull: true,
    },
    type_of_resources: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    amount: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    target_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    measurement_metric: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    numeric_value: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    target_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    kpi_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    target_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    management_plan_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    management_plan_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    management_plan_target_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    progress: {
      type: DataTypes.STRING(255),
    },
    status: {
      type: DataTypes.ENUM("Pending Approval", "Approved", "Rejected"),
      allowNull: true,
      defaultValue: "Pending Approval",
    },
    remark: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    prioritized_risks: {
      type: DataTypes.INTEGER,
    },
    legal_register: {
      type: DataTypes.INTEGER,
    },
    action_taken: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: null,
    },
  },
  {
    tableName: "objective_setting",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ObjectiveSetting.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
ObjectiveSetting.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
ObjectiveSetting.belongsTo(User, { foreignKey: "created_by", as: "CreatedBy" });
ObjectiveSetting.belongsTo(User, { foreignKey: "updated_by", as: "UpdatedBy" });

// console.log(await ObjectiveSetting.sync({ alter: true }));

export default ObjectiveSetting;
// 