import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import Activities from "./ActivitiesSchema.js";
import { EndFields } from "../constants/constants.js";
import OperationalRisk from "./OperationalRiskSchema.js";

const OperationalRiskIdentification = sequelize.define(
  "OperationalRiskIdentification",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    activity_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Activities,
        key: "id",
      },
    },
    risk_register_id:{
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: OperationalRisk,
        key: "id",
      },
    },
    name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    category: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    hazard: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    impact: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    frequency: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    probability: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    consequences: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    priority_confirmation: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    risk_rating: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    risk_ranking: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    control_assessments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    residual_rating: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    residual_ranking: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    opportunity_identification: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    opportunity_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      get() {
        const rawValue = this.getDataValue("opportunity_description");
        return rawValue ? JSON.parse(rawValue) : null;
      },
      set(value) {
        this.setDataValue("opportunity_description", JSON.stringify(value));
      },
    },
    substitution: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    engineering_control: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    administrative_control: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    last_resort: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    effectiveness: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    ...EndFields,
  },
  {
    tableName: "operational_risk_identification",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

OperationalRiskIdentification.belongsTo(Activities, {
  foreignKey: "activity_id",
  as: "activity_details",
});

OperationalRiskIdentification.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

OperationalRiskIdentification.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await OperationalRiskIdentification.sync({ alter: true }));
export default OperationalRiskIdentification;
