import ContractorForms from "./ContractorFormSchema.js";
import ContractorPreSite from "./ContractorPreSiteSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";
import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";

const PreSiteResponses = sequelize.define(
  "PreSiteResponses",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    value: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    employee_email: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "Response Pending",
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    contractor_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    client_representative: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    area: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    rectification_action: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    representative_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    supervisor_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    contract_representative: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    contract_supervisor: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    cipc_registration_number: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    contract_number: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    endorsement_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    date_of_inspection: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    contractor_pre_site_form: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorForms,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    form: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    reciept_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    comment: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    contractor_pre_site_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorPreSite,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "CASCADE",
    },
  },
  {
    timestamps: false,

    tableName: "pre_site_responses",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await PreSiteResponses.sync({ alter: true }));

export default PreSiteResponses;
