import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Incident from "./IncidentSchema.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import IncidentCategory from "./IncidentCategorySchema.js";
const SecurityIncident = sequelize.define(
  "SecurityIncident",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    category_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: IncidentCategory,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    security_incident_severity_level: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    suspects_detail: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    incident_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Incident,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    for_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    name_of_incident: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date_of_incident: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    time_of_incident: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    location_of_incident: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    incident_reference_no: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    type_of_security_incident: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    description_of_incident: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    specify_theft: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    save_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    committed_by_whom: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    specify_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    name_of_employee: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    employee_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    employee_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    what_kind_of_theft: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    estimated_cost: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    estimated_replacement_cost: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    was_case_reported_to_insurer: {
      type: DataTypes.INTEGER, // Assuming 0 or 1 as possible values
      defaultValue: 0,
      allowNull: true,
      comment: "value contains only from these Two (0 or 1) default is 0",
    },
    name_of_insurer: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    is_transnet_or_third_party_insurer: {
      type: DataTypes.INTEGER, // Assuming 0 or 1 as possible values
      defaultValue: 0,
      allowNull: true,
      comment: "value contains only from these Two (0 or 1) default is 0",
    },
    date_reported_to_insurer: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    reported_by_who_to_insurer: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    claim_number: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    who_received_the_claim: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    was_case_reported_to_saps: {
      type: DataTypes.INTEGER, // Assuming 0 or 1 as possible values
      defaultValue: 0,
      allowNull: true,
      comment: "value contains only from these Two (0 or 1) default is 0",
    },
    case_reported_to_regulator: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
      allowNull: true,
      comment: "value contains only from these Two (0 or 1) default is 0",
    },
    regulator_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date_reported: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    reported_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    estimated_cost_authority: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    state: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    region: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    city: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    financial_value: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    currency: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    insurer_employee_name: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    technical_employee_name: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    technical_department: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    technical_role: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    insurer_role_name: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    insurer_department: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    name_of_police_station_saps: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    case_number_saps: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    name_of_contact_person_saps: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    contact_details_saps: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    investigation_officer_saps: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date_of_investigation_saps: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    time_of_investigation_saps: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    person_who_reported_investigation_saps: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    any_arrest_made: {
      type: DataTypes.INTEGER, // Assuming 0 or 1 as possible values
      defaultValue: 0,
      allowNull: true,
      comment: "value contains only from these Two (0 or 1) default is 0",
    },
    how_many_arrested: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    date_of_form_submission: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    notification: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    suspect_no: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    estimated_financial_impact: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    technical_form_completed_by: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    any_recoveries: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    employee_type_arrest: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    name_of_people_arrested: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    who_was_involved_in_arrest: {
      type: DataTypes.JSON,
      allowNull: true,
      // references: {
      //   model: User,
      //   key: "id",
      // },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    police_officers_involved: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    community_members_involved: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    sap_no: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    employee_status: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    permanent_employee: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    contracted_employee: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    trainee: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    any_items_recovered: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    recovered_items: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    was_there_forced_entry: {
      type: DataTypes.TINYINT,
      defaultValue: 0,
      allowNull: true,
      comment: "(0 or 1) default is 0",
    },
    description_of_forced_entry: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    asset_number: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    location_of_asset: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    time_of_discovery: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    person_reporting_break_in: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    witness_of_break_in: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    tools_used: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    value_involved: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    value_recovered: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    form_completed_by: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    designation: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    signature: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,
    tableName: "security_incident_form",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

SecurityIncident.belongsTo(Incident, {
  foreignKey: "incident_id",
  as: "Incident",
});
SecurityIncident.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
SecurityIncident.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
SecurityIncident.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
SecurityIncident.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});
SecurityIncident.belongsTo(User, {
  foreignKey: "person_who_reported_investigation_saps",
  as: "InvestigationOfficerSAPS",
});

// console.log(await SecurityIncident.sync({ alter: true }));
export default SecurityIncident;
