import { DataTypes, Op } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Country from "./CountrySchema.js";

const State = sequelize.define(
  "State",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    country_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    country_code: {
      type: DataTypes.CHAR(2),
      allowNull: true,
    },
    fips_code: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    iso2: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    type: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    latitude: {
      type: DataTypes.DECIMAL(10, 8),
      allowNull: true,
    },
    longitude: {
      type: DataTypes.DECIMAL(11, 8),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    flag: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    wikiDataId: {
      type: DataTypes.STRING(255),
      allowNull: true,
      comment: "Rapid API GeoDB Cities",
    },
  },
  {
    tableName: "states",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_unicode_ci",
    rowFormat: "COMPACT",
  }
);
// console.log(await State.sync({ alter: true }));
export default State;
