import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";

const TemplateCategory = sequelize.define(
  "TemplateCategory",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    parent_category: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "template_category",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

TemplateCategory.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

TemplateCategory.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

TemplateCategory.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

TemplateCategory.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await TemplateCategory.sync({alter:true}))
export default TemplateCategory;
