import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Incident from "./IncidentSchema.js";
import CategoryType from "./CategoryTypeSchema.js";
import User from "./UserSchema.js";

const VehicleIncidentForm = sequelize.define(
  "VehicleIncidentForm",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    incident_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Incident,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    for_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    category_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: CategoryType,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    incident_title: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    incident_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    incident_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    incident_severity: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    incident_category: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    incident_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    incident_location: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    immediate_cause_of_incident: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    name_of_road: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    location: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    injured_persons: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    technical_form_completed_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    role_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date_of_submission: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    notification: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    save_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    department: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    organization: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "vehicle_incident_form",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

VehicleIncidentForm.belongsTo(Incident, {
  foreignKey: "incident_id",
  as: "Incident",
});

VehicleIncidentForm.belongsTo(CategoryType, {
  foreignKey: "category_id",
  as: "CategoryType",
});

VehicleIncidentForm.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

VehicleIncidentForm.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await VehicleIncidentForm.sync({ alter: true }));
export default VehicleIncidentForm;
